Images.MenuBG = LoadImage("Back.png");
Images.Selector = LoadImage("Selector.png");

function OpenSubmenu()
{
	var image = GrabImage(0, 0, 320, 240);
	for (var alpha = 0; alpha < 255; alpha += 30)
	{
		image.blit(0, 0);
		Fade(alpha, Colors.Black);
		FlipScreen();
	}
	for (var alpha = 255; alpha > 0; alpha -= 40)
	{
		DrawSubmenu();
		Fade(alpha, Colors.Black);
		FlipScreen();
	}
	Game.menuopen = true;
	Submenu();
	for (var alpha = 0; alpha < 255; alpha += 40)
	{
		DrawSubmenu();
		Fade(alpha, Colors.Black);
		FlipScreen();
	}
}

function DrawBG()
{
	Images.MenuBG.blit(0, 0);
}

function InfoWindow(x, y)
{
	window.drawWindow(x, y, 60, 38, true, "INFO");
	font.drawText(x-2, y+2, "Play Time");
	font.drawText(x+16, y+12, Game.clock.getTime());
	font.drawText(x-2, y+22, "Money");
	font.drawText(x+64, y+32, Game.money+"$", "right");
}

function HelpWindow(x, y, w, description)
{
	window.drawWindow(x, y, w, 8, true, "HELP");
	font.drawText(x-2, y+2, description);
}

function Submenu()
{
	Game.menuopen = true;
	while (Game.menuopen)
	{
		DrawSubmenu();
		Game.submenu.execute(20, 14, 60, 10);
		FlipScreen();
	}
}

function DrawSubmenu()
{
	DrawBG();
	for (var i = 0; i < Game.psize; i ++)
	{
		window.partyWindow(140 - (i * 20), 51 + (i * 44), Game.party[i]);
	}
	if (Game.psize < Game.party.length)
	{
		window.drawWindow(229, 140, 82, 48, true, "PARTY");
		for (var i = 0; i < Game.party.length - Game.psize; i ++)
		{
			font.drawText(227, 142, Game.party[i + Game.psize].name);
			font.drawText(290, 142, "LV");
			font.drawText(315, 142, Game.party[i + Game.psize].lv, "right");
		}
	}
	InfoWindow(20, 130);
}

function StatusMenu()
{
	var character = SelectCharacter();
	if (character == false)
	{
		Submenu();
	}
	Game.menuopen = true;
	while (Game.menuopen)
	{
		DrawStatusMenu(Game.party[character]);
		FlipScreen();
	}
}

function DrawStatusMenu(character)
{
	DrawBG();
	window.drawWindow(20, 18, 60, 6, true, "MENU");
	font.drawText(20, 20, "Status");
	window.drawWindow(20, 42, 48, 48, true);
	window.partyWindow(75, 67, character);
	window.drawWindow(202, 74, 98, 38, true, "EQUIPMENT");
	window.drawWindow(20, 124, 110, 84, true, "ATTRIBUTES");
	font.drawText(20, 126, "Strength");
	font.drawText(20, 136, "Dexterity");
	font.drawText(20, 146, "Constitution");
	font.drawText(20, 156, "Intelligence");
	font.drawText(20, 170, "Attack");
	font.drawText(20, 180, "Defense");
	font.drawText(20, 190, "Magic Attack");
	font.drawText(20, 200, "Magic Defense");
	if (AreKeysLeft())
	{
		switch (GetKey())
		{
			case Game.cancel:
				Game.menuopen = false;
				break;
		}
	}
}

function DrawItemmenu()
{

}

function SelectCharacter()
{
	Game.menuopen = true;
	var returned = false;
	var selection = 0;
	while (Game.menuopen)
	{
		DrawSubmenu();
		if (selection < 2)
		{
			DrawCursor(138 - selection * 20, 45 + selection * 44);
		}
		else
			;
		// Draw icon for selector
		FlipScreen();
		// Control selection
		if (AreKeysLeft())
		{
			switch (GetKey())
			{
				case KEY_UP:
					break;
				case KEY_DOWN:
					break;
				case KEY_LEFT:
					break;
				case KEY_RIGHT:
					break;
				case Game.accept:
					Game.menuopen = false;
					returned = true;
					break;
				case Game.cancel:
					Game.menuopen = false;
					returned = false;
					break;
			}
		}
	}
	if (returned == true)
	{
		return selection;
	}
	else
		return false;
}